//
//  AppDelegate.m
//  Kyopon Schedule Sync
//
//  Created by FUJIDANA on 06/09/18.
//  Copyright FUJIDANA 2006. All rights reserved.
//

#import "AppDelegate.h"

@implementation AppDelegate

/**
    Returns the support folder for the application, used to store the Core Data
    store file.  This code uses a folder named "Kyopon_Schedule_Sync" for
    the content, either in the NSApplicationSupportDirectory location or (if the
    former cannot be found), the system's temporary directory.
 */

- (NSString *)applicationSupportFolder
{
	NSArray *paths = NSSearchPathForDirectoriesInDomains(NSApplicationSupportDirectory, NSUserDomainMask, YES);
	NSString *basePath = ([paths count] > 0) ? [paths objectAtIndex:0] : NSTemporaryDirectory();
	return [basePath stringByAppendingPathComponent:@"Kyopon Utilities"];
}

- (NSManagedObjectModel *)managedObjectModel
{
	if (managedObjectModel != nil) {
		return managedObjectModel;
	}

	NSMutableSet *allBundles = [[NSMutableSet alloc] init];
	[allBundles addObject: [NSBundle mainBundle]];
	[allBundles addObjectsFromArray: [NSBundle allFrameworks]];

	managedObjectModel = [[NSManagedObjectModel mergedModelFromBundles: [allBundles allObjects]] retain];
	[allBundles release];

	return managedObjectModel;
}


- (NSPersistentStoreCoordinator *)persistentStoreCoordinator
{
	if (persistentStoreCoordinator != nil) {
		return persistentStoreCoordinator;
	}

	NSFileManager *fileManager;
	NSString *applicationSupportFolder = nil;
	NSURL *url;
	NSError *error;
	
	fileManager = [NSFileManager defaultManager];
	applicationSupportFolder = [self applicationSupportFolder];
	if ( ![fileManager fileExistsAtPath:applicationSupportFolder isDirectory:NULL] ) {
		[fileManager createDirectoryAtPath:applicationSupportFolder attributes:nil];
	}
	
	url = [NSURL fileURLWithPath:[applicationSupportFolder stringByAppendingPathComponent: @"KyoponScheduleSync.wxkxml"]];
	
//	if ([fileManager fileExistsAtPath:path] == NO) {
//	
//	}
	
	persistentStoreCoordinator = [[NSPersistentStoreCoordinator alloc] initWithManagedObjectModel:[self managedObjectModel]];
	if (![persistentStoreCoordinator addPersistentStoreWithType:NSXMLStoreType configuration:nil URL:url options:nil error:&error]) {
		[[NSApplication sharedApplication] presentError:error];
	}    
	
	return persistentStoreCoordinator;
}


/**
    Returns the managed object context for the application (which is already
    bound to the persistent store coordinator for the application.) 
 */
 
- (NSManagedObjectContext *) managedObjectContext
{
	if (managedObjectContext != nil) {
		return managedObjectContext;
	}
	
	NSPersistentStoreCoordinator *coordinator = [self persistentStoreCoordinator];
	if (coordinator != nil) {
		managedObjectContext = [[NSManagedObjectContext alloc] init];
		[managedObjectContext setPersistentStoreCoordinator: coordinator];
	}
	
	return managedObjectContext;
}


- (NSUndoManager *)windowWillReturnUndoManager:(NSWindow *)window
{
	return [[self managedObjectContext] undoManager];
}


- (IBAction) saveAction:(id)sender
{
	NSError *error = nil;
	if (![[self managedObjectContext] save:&error]) {
		[[NSApplication sharedApplication] presentError:error];
	}
}


- (NSApplicationTerminateReply)applicationShouldTerminate:(NSApplication *)sender
{
	NSError *error;
	int reply = NSTerminateNow;
	
	if (managedObjectContext != nil) {
		if ([managedObjectContext commitEditing]) {
			if ([managedObjectContext hasChanges] && ![managedObjectContext save:&error]) {
				
				// This error handling simply presents error information in a panel with an 
				// "Ok" button, which does not include any attempt at error recovery (meaning, 
				// attempting to fix the error.)  As a result, this implementation will 
				// present the information to the user and then follow up with a panel asking 
				// if the user wishes to "Quit Anyway", without saving the changes.

				// Typically, this process should be altered to include application-specific 
				// recovery steps.  

				BOOL errorResult = [[NSApplication sharedApplication] presentError:error];
				
				if (errorResult == YES) {
					reply = NSTerminateCancel;
				} else {
					int alertReturn = NSRunAlertPanel(nil, @"Could not save changes while quitting. Quit anyway?" , @"Quit anyway", @"Cancel", nil);
					if (alertReturn == NSAlertAlternateReturn) {
						reply = NSTerminateCancel;	
					}
				}
			}
		} else {
			reply = NSTerminateCancel;
		}
	}
	return reply;
}

- (void)dealloc
{
    [managedObjectContext release], managedObjectContext = nil;
    [persistentStoreCoordinator release], persistentStoreCoordinator = nil;
    [managedObjectModel release], managedObjectModel = nil;
	
    [super dealloc];
}

//- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
//{
//	NSNotificationCenter *defaultCenter = [NSNotificationCenter defaultCenter];
//	[defaultCenter addObserver:self
//					  selector:@selector(workspaceDidMount:)
//						  name:NSWorkspaceDidMountNotification
//						object:nil];
//}
//
//- (void)workspaceDidMount:(NSNotification *)aNotification
//{
//	NSLog(@"%@", [[aNotification userInfo] objectForKey:@"NSDevicePath"]);
//}

@end
